/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.udp.wifi.set;

import com.gprinter.udp.CommandUDP;
import com.gprinter.udp.Response;
import com.gprinter.udp.wifi.set.ResultResp;

public class SettingStaLannCommand
extends CommandUDP {
    private String ip;
    private String mask;
    private String gateWay;
    private boolean dhcp;

    public SettingStaLannCommand(boolean dhcp) {
        this.dhcp = dhcp;
    }

    public SettingStaLannCommand(boolean dhcp, String ip, String mask, String gateWay) {
        this.dhcp = dhcp;
        this.ip = ip;
        this.mask = mask;
        this.gateWay = gateWay;
    }

    @Override
    public byte[] getCommand() {
        return this.getAT_WANN(this.dhcp, this.ip, this.mask, this.gateWay).getBytes();
    }

    @Override
    public Response resolveResponseData(long uuid, byte[] data) {
        try {
            if (data != null) {
                String response = new String(data);
                ResultResp resultResp = new ResultResp();
                if (response.contains("+ok")) {
                    resultResp.setResult(true);
                } else {
                    resultResp.setResult(false);
                }
                return resultResp;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getAT_WANN(boolean dhcp, String ip, String mask, String gateway) {
        String cmd = new String();
        if (dhcp) {
            cmd = "AT+WANN=DHCP\r";
        } else {
            cmd = "AT+WANN=static,";
            cmd = cmd + ip;
            cmd = cmd + ",";
            cmd = cmd + mask;
            cmd = cmd + ",";
            cmd = cmd + gateway;
            cmd = cmd + "\r";
        }
        return cmd;
    }
}

